<?php
/**
 * Welcome Admin page.
 *
 * @author     ThemeFusion
 * @copyright  (c) Copyright by ThemeFusion
 * @link       https://theme-fusion.com
 * @package    Avada
 * @subpackage Core
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<?php self::get_admin_screens_header( 'welcome' ); ?>
	<?php
	ob_start();
if (  Avada_Pro::is_activated() === true  ) {
	Avada()->registration->the_form(); 
        } else { 
    echo "لایسنس خود را در قسمت : پیشخوان وردپرس » تنظیمات » ثبت قالب آوادا وارد کنید . سپس این قسمت خودکار تکمیل خواهد شد";
}
	$reg_form = ob_get_clean();
	?>

	<div class="avada-db-welcome-wrapper">
		<?php
		$completed_reg = Avada()->registration->appear_registered() ? ' avada-db-completed avada-db-onload-completed' : '';

		// Should Skip wizard permanntly?
		if ( isset( $_GET['skip-wizard'] ) && 'true' === $_GET['skip-wizard'] ) { // phpcs:ignore WordPress.Security.NonceVerification
			update_option( 'awb_skip_wizard', 'yes' );
		}

		$setup_completed = '';
		$the_user        = wp_get_current_user();
		$fresh_install   = get_transient( 'awb_fresh_install' );
		$should_skip     = get_option( 'awb_skip_wizard' );
		if ( 'yes' === $should_skip || ( $completed_reg && ( ! $fresh_install || 'fresh' !== $fresh_install ) ) ) {
			$setup_completed = ' avada-db-welcome-setup-completed';
		}
		?>
		<section id="avada-db-registration" class="avada-db-card avada-db-registration<?php echo esc_attr( $completed_reg ); ?>">
			<?php echo $reg_form; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</section>

		<section class="avada-db-card avada-db-main-setup avada-db-welcome-setup<?php echo esc_attr( $setup_completed ); ?>">
			<div class="avada-db-welcome-container">
				<div class="avada-db-welcome-intro">
					<div class="avada-db-card-caption">
						<?php if ( '' === $setup_completed ) : ?>
							<?php /* translators: %s: The username. */ ?>
							<h1 class="avada-db-welcome-heading"><?php echo esc_html( sprintf( apply_filters( 'avada_admin_welcome_title', __( 'Welcome To Avada, %s!', 'Avada' ) ), ucfirst( $the_user->display_name ) ) ); ?></h1>
							<p class="avada-db-welcome-text"><?php echo esc_html( apply_filters( 'avada_admin_setup_welcome_text', __( 'Launch the Avada setup wizard, the easiest way to get your website started.', 'Avada' ) ) ); ?></p>
						<?php else : ?>
							<?php /* translators: %s: The username. */ ?>
							<h1 class="avada-db-welcome-heading"><?php echo esc_html( sprintf( apply_filters( 'avada_admin_welcome_title_completed', __( 'Hello %s!', 'Avada' ) ), ucfirst( $the_user->display_name ) ) ); ?></h1>
							<p class="avada-db-welcome-text"><?php echo esc_html( apply_filters( 'avada_admin_setup_welcome_text_completed', __( 'Welcome back to the Avada dashboard. Take a look at our latest update.', 'Avada' ) ) ); ?></p>
						<?php endif; ?>
					</div>

			<?php // Filter for the dashboard welcome content. ?>
			<?php ob_start(); ?>
			<?php if ( '' !== $setup_completed ) : ?>
					<a class="avada-db-welcome-video" href="#">
						<span class="avada-db-welcome-video-icon">
							<span class="avada-db-triangle"></span>
						</span>
						<?php /* translators: %s: version number. */ ?>
						<span class="avada-db-welcome-video-text"><?php echo esc_html( sprintf( __( 'What’s New In Avada %s', 'Avada' ), AVADA_VERSION ) ); ?></span>
					</a>
				<?php else : ?>
					<a class="avada-db-get-started-button" href="<?php echo esc_url( admin_url( 'admin.php?page=avada-setup' ) ); ?>"><?php esc_html_e( 'Get Started', 'Avada' ); ?></a>
				<?php endif; ?>
				</div>
				<div class="avada-db-welcome-media-container">
					<?php if ( '' !== $setup_completed ) : ?>
						<?php $welcome_video = self::get_dashboard_screen_video_url(); ?>
						<img class="avada-db-welcome-image" src="<?php echo esc_url( get_template_directory_uri() . '/assets/admin/images/welcome-completed.png' ); ?>" alt="<?php esc_html_e( 'Avada Welcome Image', 'Avada' ); ?>" width="646" height="400">
						<iframe class="avada-db-welcome-video-iframe" data-src="<?php echo esc_url( $welcome_video ); ?>" width="100%" height="100%" frameborder="0"></iframe>
					<?php else : ?>
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/admin/images/welcome.png' ); ?>" alt="<?php esc_html_e( 'Avada Welcome Image', 'Avada' ); ?>" width="646" height="400">
					<?php endif; ?>
				</div>
			</div>
			<?php $welcome_html = ob_get_clean(); ?>
			<?php echo apply_filters( 'avada_admin_welcome_screen_content', $welcome_html ); // phpcs:ignore WordPress.Security.EscapeOutput ?>
		</section>

	</div>
	<?php $this->get_admin_screens_footer(); ?>
